import '../../../core/utils/method.dart';
import '../../../core/utils/url_container.dart';
import '../../model/global/response_model/response_model.dart';
import '../../services/api_service.dart';

class AutoPaymentRepo {
  ApiClient apiClient;
  AutoPaymentRepo({required this.apiClient});

  Future<ResponseModel> getAllAutoPaymentData() async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.autoPayment}";
    ResponseModel responseModel = await apiClient.request(url, Method.getMethod, null, passHeader: true);
    return responseModel;
  }


    Future<ResponseModel> deleteAutoPayment(String id) async {
    String url = "${UrlContainer.baseUrl}${UrlContainer.autoPaymentRemove}/$id";

    ResponseModel responseModel = await apiClient.request(url, Method.postMethod, null, passHeader: true);
    return responseModel;
  }
}
